package gov.va.vinci.dart.db.impl;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import gov.va.vinci.dart.biz.RequestAdminLocationDocument;
import gov.va.vinci.dart.db.RequestAdminLocationDocumentDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class RequestAdminLocationDocumentDAOImpl extends HibernateDAO implements RequestAdminLocationDocumentDAO {

	@Override
	@SuppressWarnings("unchecked")
	public List<RequestAdminLocationDocument> listByRequestId(final int requestId) {
		Query q = createQuery("from RequestAdminLocationDocument where requestId=:rid");
		q.setParameter("rid",requestId);
		try {
			return (List<RequestAdminLocationDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result list then
			return new ArrayList<RequestAdminLocationDocument>();
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<RequestAdminLocationDocument> listByDocumentId(final int documentId) {
		Query q = createQuery("from RequestAdminLocationDocument where documentId=:did");
		q.setParameter("did", documentId);
		try {
			return (List<RequestAdminLocationDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result list then
			return new ArrayList<RequestAdminLocationDocument>();
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<RequestAdminLocationDocument> listByRequestIdAndGroupId(final int requestId, final int groupId) {
		Query q = createQuery("from RequestAdminLocationDocument where requestId=:rid and groupId=:gid");
		q.setParameter("rid",requestId);
		q.setParameter("gid",groupId);		
		try {
			return (List<RequestAdminLocationDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result list then
			return new ArrayList<RequestAdminLocationDocument>();
		}
	}

	@Override
	public void save(RequestAdminLocationDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(document);
	}

	@Override
	public void delete(RequestAdminLocationDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.delete(document);
	}
}
